#ifndef LLF_RSA_KG_H
#define LLF_RSA_KG_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Wed Mar 07 12:34:11 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level utility
* functions for key-pair generation functions RSA cryptography,
* which worked with LibTomCrypt.
* 
* \version LLF_RSA_KG.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_RSA_KG_GenerateKeyPair
*
* Inputs:
*  @param PubExp_ptr [in] - The pointer to the public exponent (public key);
*  @param PubExpSizeInBytes [in] - The public exponent size in bits;
*  @param KeySize [in] - The size of the key, in bits;
*  @param UserPrivKey_ptr [out] - A pointer to the private key structure;
*  @param UserPubKey_ptr  [out] - A pointer to the public key structure.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_EXPONENT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_INVALID_MODULUS_SIZE,
*     - CE2_RSA_INVALID_EXPONENT_SIZE.
*
* \brief \b
* Description:
*  LLF_RSA_KG_GenerateKeyPair generates a Pair of public and
*  private keys on non CRT mode.
*
* \b
* Algorithm:
*  -# Register and initialize prng and hash;
*  -# Generate RSA private and public keys using exponent and key
*     size;
*  -# Build public and private keys using previously generated 
*     RSA keys and using LLF_RSA_rsakey_TO_UserPubKey,
*     LLF_RSA_rsakey_TO_UserPrivKey.
***************************************************************/
CE2Error_t LLF_RSA_KG_GenerateKeyPair(
                        DxUint8_t            *PubExp_ptr,		/* in */
                        DxUint16_t            PubExpSizeInBytes,/* in */
                        DxUint32_t            KeySize,			/* in */
                        CE2_RSAUserPrivKey_t *UserPrivKey_ptr,	/* out */
                        CE2_RSAUserPubKey_t  *UserPubKey_ptr);	/* out */

/**
****************************************************************
* Function Name: 
*  LLF_RSA_KG_GenerateKeyPairCRT
*
* Inputs:
*  @param PubExp_ptr [in] - The pointer to the public exponent (public key);
*  @param PubExpSizeInBytes [in] - The public exponent size in bits;
*  @param KeySize [in] - The size of the key, in bits;
*  @param UserPrivKey_ptr [out] - A pointer to the private key structure;
*  @param UserPubKey_ptr  [out] - A pointer to the public key structure.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_EXPONENT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_INVALID_MODULUS_SIZE,
*     - CE2_RSA_INVALID_EXPONENT_SIZE.
*
* \brief \b
* Description:
*  LLF_RSA_KG_GenerateKeyPairCRT generates a Pair of public and
*  private keys on CRT mode.
*
* \b
* Algorithm:
*  -# Register and initialize prng and hash;
*  -# Generate RSA private and public keys using exponent and key
*     size;
*  -# Build public and private keys using previously generated 
*     RSA keys and using LLF_RSA_rsakey_TO_UserPubKey,
*     LLF_RSA_rsakey_TO_UserPrivKey on CRT mode.
***************************************************************/
CE2Error_t LLF_RSA_KG_GenerateKeyPairCRT(
                        DxUint8_t            *PubExp_ptr,		/* in */
                        DxUint16_t            PubExpSizeInBytes,/* in */
                        DxUint32_t            KeySize,			/* in */
                        CE2_RSAUserPrivKey_t *UserPrivKey_ptr,	/* out */
                        CE2_RSAUserPubKey_t  *UserPubKey_ptr);	/* out */


#ifdef __cplusplus
}
#endif

#endif /* LLF_RSA_KG_H */
